<?php
/* --------------------------------------------------------------
   DeletedMultipleWithdrawals.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Events;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalIds;

/**
 * Class DeletedMultipleWithdrawals
 *
 * @package Gambio\Admin\Withdrawal\Events
 */
class DeletedMultipleWithdrawals
{
    /**
     * @var WithdrawalIds
     */
    private $withdrawalIds;
    
    
    /**
     * DeletedMultipleWithdrawalsEvent constructor.
     *
     * @param WithdrawalIds $withdrawalIds
     */
    private function __construct(WithdrawalIds $withdrawalIds)
    {
        $this->withdrawalIds = $withdrawalIds;
    }
    
    
    /**
     * @param WithdrawalIds $withdrawalIds
     *
     * @return DeletedMultipleWithdrawals
     */
    public static function create(WithdrawalIds $withdrawalIds): DeletedMultipleWithdrawals
    {
        return new self($withdrawalIds);
    }
    
    
    /**
     * @return WithdrawalIds
     */
    public function withdrawalIds(): WithdrawalIds
    {
        return $this->withdrawalIds;
    }
}